<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="sui-wrap  wpmudev-forminator-forminator">

    <div class="sui-upgrade-page">

        <div class="sui-upgrade-page-header">

            <div class="sui-upgrade-page__container">

                <div class="sui-upgrade-page-header__content">

					<h1><?php esc_html_e( 'Upgrade to Forminator Pro', Forminator::DOMAIN ); ?></h1>

					<p><?php esc_html_e( 'Get premium form fields, 24/7 live WordPress support, and early access to new features with Forminator Pro.', Forminator::DOMAIN ); ?></p>

					<p><?php esc_html_e( 'Plus - you\'ll get a WPMU DEV membership, which includes our award-winning Smush Pro image optimization plugin, white label reporting, unlimited usage of all our premium plugins, managed hosting credits, and more.', Forminator::DOMAIN ); ?></p>

                    <a href="https://premium.wpmudev.org/project/forminator-pro/?utm_source=forminator&utm_medium=plugin&utm_campaign=forminator_propage_topbutton" target="_blank" class="sui-button sui-button-lg sui-button-purple">
						<?php esc_html_e( 'Try Forminator Pro for Free Today', Forminator::DOMAIN ); ?>
					</a>

            	<div class="sui-reviews" aria-hidden="true" tabindex="-1">

						<span class="sui-reviews__stars"></span>

						<div class="sui-reviews__rating"><span class="sui-reviews-rating">-</span> / <?php esc_html_e( '5.0 rating from', Forminator::DOMAIN ); ?> <span class="sui-reviews-customer-count">-</span> <?php esc_html_e( 'customers', Forminator::DOMAIN ); ?></div>

                  <a href="https://www.reviews.io/company-reviews/store/wpmudev-org" target="_blank" class="sui-reviews__link">
                      Reviews.io<i class="sui-icon-arrow-right" aria-hidden="true"></i>
						</a>

					</div>

					<div class="sui-screen-reader-text">
						<p><?php esc_html_e( '4.96 / 5.0 rating from 1155 customers', Forminator::DOMAIN ); ?></p>
						<a href="https://www.reviews.io/company-reviews/store/wpmudev-org" target="_blank"><?php esc_html_e( 'Go to Review.io to read more about', Forminator::DOMAIN ); ?></a>
					</div>

                </div>

				<div class="sui-upgrade-page-header__image"></div>

			</div>

		</div>

        <div class="sui-upgrade-page-features">
            <div class="sui-upgrade-page-features__header">
                <h2><?php esc_html_e( 'Pro Features', Forminator::DOMAIN ); ?></h2>
                <p><?php esc_html_e( 'Upgrading to Pro will get you the following benefits.', Forminator::DOMAIN ); ?></p>
            </div>
		</div>

        <div class="sui-upgrade-page__container">
            <div class="sui-upgrade-page-features__items">
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-unlock" aria-hidden="true"></i>
                    <h3><?php esc_html_e( 'Premium form fields and early access to new features', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'Forminator Pro comes with premium form fields such as E-signature and many more coming soon. You\'ll also get early access to all the new features we release.', Forminator::DOMAIN ); ?></p>
                </div>
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-photo-picture" aria-hidden="true"></i>
                    <h3><?php esc_html_e( 'White label Branding', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'We love our superhero branding, but we know it\'s not for everyone. With a Pro membership, you can remove our superhero branding and replace it with your own.', Forminator::DOMAIN ); ?></p>
                </div>
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-smush" aria-hidden="true"></i>
                    <h3><?php esc_html_e( 'Smush Pro and Hummingbird Pro - the ultimate site optimization & performance package.', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'Smush\'s award-winning image optimization + Hummingbird\'s performance optimization gives you the fastest possible WordPress site. It\'s a powerful combination that your visitors, customers, and search engines will love.', Forminator::DOMAIN ); ?></p>
                </div>
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-gdpr" aria-hidden="true"></i>
                    <h3><?php esc_html_e( 'Premium WordPress plugins', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'In addition to Forminator Pro, you\'ll get our full suite of premium WordPress plugins. From security to backups to marketing and SEO, you\'ve got all the WordPress solutions you\'ll need to build, promote and manage your website. Get access to unlimited usage across all your sites. Join more than 1 million users with our plugins.', Forminator::DOMAIN ); ?></p>
                </div>
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-hub" aria-hidden="true"></i>
                    <h3><?php esc_html_e( 'The Hub - Manage unlimited WordPress sites', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'You can manage unlimited WordPress sites with automated updates, backups, security, and performance checks, all in one place. All of this can be white labeled for your clients, and you even get our 24/7 live WordPress support. ', Forminator::DOMAIN ); ?></p>
                </div>
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-help-support" aria-hidden="true"></i>
                    <h3><?php esc_html_e( '24/7 live WordPress support', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'We can\'t stress this enough: our outstanding WordPress support is available with live chat 24/7, and we\'ll help you with absolutely any WordPress issue - not just our products. It\'s an expert WordPress team on call for you, whenever you need them. ', Forminator::DOMAIN ); ?></p>
                </div>
                <div class="sui-upgrade-page-features__item">
                    <i class="sui-icon-wpmudev-logo" aria-hidden="true"></i>
                    <h3><?php esc_html_e( 'The WPMU DEV Guarantee', Forminator::DOMAIN ); ?></h3>
                    <p><?php esc_html_e( 'You\'ll be delighted with Forminator Pro and everything else included in your membership 😁 You can trial the plugin first with a WPMU DEV Membership, and if you continue but change your mind, you can cancel any time.', Forminator::DOMAIN ); ?></p>
                </div>
            </div>
		</div>

        <div class="sui-upgrade-page-cta">
            <div class="sui-upgrade-page-cta__inner">
                <h2><?php esc_html_e( 'Join 771,093 Happy Members', Forminator::DOMAIN ); ?></h2>
                <p><?php esc_html_e( '97% of customers are happy with WPMU DEV\'s service, and it\'s a great time to join them: as a Forminator user you\'ll get a free trial period, so you can see what all the fuss is about. ', Forminator::DOMAIN ); ?></p>
                <a href="https://premium.wpmudev.org/project/forminator-pro/?utm_source=forminator&utm_medium=plugin&utm_campaign=forminator_propage_bottombutton" class="sui-button sui-button-lg sui-button-purple" style="color: white;" target="_blank">
					<?php esc_html_e( 'Get Forminator Pro, and get a better WordPress', Forminator::DOMAIN ); ?>
                </a>
                <button type="button" class="sui-button sui-button-lg sui-button-purple sui-hidden-desktop">
					<?php esc_html_e( 'Get Forminator Pro and get a better WordPress', Forminator::DOMAIN ); ?>
                </button>
                <a href="https://premium.wpmudev.org/project/forminator-pro/?utm_source=forminator&utm_medium=plugin&utm_campaign=forminator_propage_bottombutton" target="_blank">
					<?php esc_html_e( 'Try Pro for Free Today', Forminator::DOMAIN ); ?>
                </a>
            </div>
		</div>

	</div>

	<?php $this->render_footer(); ?>

</div>
